# Generated by Django 4.0 on 2022-11-24 09:01

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('users', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('title', models.CharField(max_length=200, null=True)),
                ('tag', models.CharField(max_length=200, null=True)),
                ('status', models.CharField(choices=[('❗️To Do', '❗️To Do'), ('⏳In-progress', '⏳In-progress'), ('🙌Completed', '🙌Completed')], max_length=200, null=True)),
                ('due_date', models.DateField(max_length=200, null=True)),
                ('task_description', models.TextField(max_length=2000, null=True)),
                ('number_of_notes', models.IntegerField(blank=True, default=0, null=True)),
                ('updated_time_stamp', models.DateTimeField(auto_now=True)),
                ('created_time_stamp', models.DateTimeField(auto_now_add=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('account_owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='users.profile')),
            ],
        ),
        migrations.CreateModel(
            name='Note',
            fields=[
                ('new_note', models.CharField(blank=True, max_length=255, null=True)),
                ('updated_time_stamp', models.DateTimeField(auto_now=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('task', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='task.task')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='users.profile')),
            ],
            options={
                'ordering': ['-updated_time_stamp'],
            },
        ),
    ]
